def calc_breaks(P):
    breaks = 0
    for i in range(len(P) - 1):
        if P[i] > P[i + 1]:
            breaks += 1
    return breaks

def update_breaks(P, breaks, i, j):
    n = len(P)
    indices = set()
    for x in [i - 1, i, j - 1, j]:
        if 0 <= x < n - 1:
            indices.add(x)

    old = sum(P[x] > P[x + 1] for x in indices)

    P[i], P[j] = P[j], P[i]

    new = sum(P[x] > P[x + 1] for x in indices)

    return breaks - old + new
    
N, Q = map(int, input().split())
P = list(map(int, input().split()))
queries = [tuple(map(int, input().split())) for _ in range(Q)]

results = []

breaks = calc_breaks(P)
results.append(breaks)

for i, j in queries:
    i -= 1
    j -= 1
    breaks = update_breaks(P, breaks, i, j)
    results.append(breaks)

print('\n'.join(map(str, results)))